
use builtin;
use str;

set edit:completion:arg-completer[tree-sitter] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'tree-sitter'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'tree-sitter'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand init-config 'Generate a default config file'
            cand init 'Initialize a grammar repository'
            cand generate 'Generate a parser'
            cand build 'Compile a parser'
            cand parse 'Parse files'
            cand test 'Run a parser''s tests'
            cand version 'Increment the version of a grammar'
            cand fuzz 'Fuzz a parser'
            cand query 'Search files using a syntax tree query'
            cand highlight 'Highlight a file'
            cand tags 'Generate a list of tags'
            cand playground 'Start local playground for a parser in the browser'
            cand dump-languages 'Print info about all known language parsers'
            cand complete 'Generate shell completions'
        }
        &'tree-sitter;init-config'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;init'= {
            cand -u 'Update outdated files'
            cand --update 'Update outdated files'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;generate'= {
            cand --abi 'Select the language ABI version to generate (default 15). Use --abi=latest to generate the newest supported version (15).'
            cand --libdir 'The path to the directory containing the parser library'
            cand -o 'The path to output the generated source files'
            cand --output 'The path to output the generated source files'
            cand --report-states-for-rule 'Produce a report of the states for the given rule, use `-` to report every rule'
            cand --js-runtime 'The name or path of the JavaScript runtime to use for generating parsers'
            cand -l 'Show debug log during generation'
            cand --log 'Show debug log during generation'
            cand --no-bindings 'Deprecated (no-op)'
            cand -b 'Compile all defined languages in the current dir'
            cand --build 'Compile all defined languages in the current dir'
            cand -0 'Compile a parser in debug mode'
            cand --debug-build 'Compile a parser in debug mode'
            cand --json 'Report conflicts in a JSON format'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;build'= {
            cand -o 'The path to output the compiled file'
            cand --output 'The path to output the compiled file'
            cand -w 'Build a WASM module instead of a dynamic library'
            cand --wasm 'Build a WASM module instead of a dynamic library'
            cand -d 'Run emscripten via docker even if it is installed locally (only if building a WASM module with --wasm)'
            cand --docker 'Run emscripten via docker even if it is installed locally (only if building a WASM module with --wasm)'
            cand --reuse-allocator 'Make the parser reuse the same allocator as the library'
            cand -0 'Compile a parser in debug mode'
            cand --debug 'Compile a parser in debug mode'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;parse'= {
            cand --paths 'The path to a file with paths to source file(s)'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand -d 'Show parsing debug log'
            cand --debug 'Show parsing debug log'
            cand --timeout 'Interrupt the parsing process by timeout (µs)'
            cand --edits 'Apply edits in the format: \"row,col|position delcount insert_text\", can be supplied multiple times'
            cand --encoding 'The encoding of the input files'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Parse the contents of a specific test'
            cand --test-number 'Parse the contents of a specific test'
            cand -0 'Compile a parser in debug mode'
            cand --debug-build 'Compile a parser in debug mode'
            cand -D 'Produce the log.html file with debug graphs'
            cand --debug-graph 'Produce the log.html file with debug graphs'
            cand --wasm 'Compile parsers to wasm instead of native dynamic libraries'
            cand --dot 'Output the parse data with graphviz dot'
            cand -x 'Output the parse data in XML format'
            cand --xml 'Output the parse data in XML format'
            cand -c 'Output the parse data in a pretty-printed CST format'
            cand --cst 'Output the parse data in a pretty-printed CST format'
            cand -s 'Show parsing statistic'
            cand --stat 'Show parsing statistic'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand --open-log 'Open `log.html` in the default browser, if `--debug-graph` is supplied'
            cand -j 'Output parsing results in a JSON format'
            cand --json 'Output parsing results in a JSON format'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand --no-ranges 'Omit ranges in the output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;test'= {
            cand -i 'Only run corpus test cases whose name matches the given regex'
            cand --include 'Only run corpus test cases whose name matches the given regex'
            cand -e 'Only run corpus test cases whose name does not match the given regex'
            cand --exclude 'Only run corpus test cases whose name does not match the given regex'
            cand --file-name 'Only run corpus test cases from from a given filename'
            cand --config-path 'The path to an alternative config.json file'
            cand --stat 'Show parsing statistics'
            cand -u 'Update all syntax trees in corpus files with current parser output'
            cand --update 'Update all syntax trees in corpus files with current parser output'
            cand -d 'Show parsing debug log'
            cand --debug 'Show parsing debug log'
            cand -0 'Compile a parser in debug mode'
            cand --debug-build 'Compile a parser in debug mode'
            cand -D 'Produce the log.html file with debug graphs'
            cand --debug-graph 'Produce the log.html file with debug graphs'
            cand --wasm 'Compile parsers to wasm instead of native dynamic libraries'
            cand --open-log 'Open `log.html` in the default browser, if `--debug-graph` is supplied'
            cand --show-fields 'Force showing fields in test diffs'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand --overview-only 'Show only the pass-fail overview tree'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;version'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;fuzz'= {
            cand -s 'List of test names to skip'
            cand --skip 'List of test names to skip'
            cand --subdir 'Subdirectory to the language'
            cand --edits 'Maximum number of edits to perform per fuzz test'
            cand --iterations 'Number of fuzzing iterations to run per test'
            cand -i 'Only fuzz corpus test cases whose name matches the given regex'
            cand --include 'Only fuzz corpus test cases whose name matches the given regex'
            cand -e 'Only fuzz corpus test cases whose name does not match the given regex'
            cand --exclude 'Only fuzz corpus test cases whose name does not match the given regex'
            cand --log-graphs 'Enable logging of graphs and input'
            cand -l 'Enable parser logging'
            cand --log 'Enable parser logging'
            cand -r 'Force rebuild the parser'
            cand --rebuild 'Force rebuild the parser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;query'= {
            cand --paths 'The path to a file with paths to source file(s)'
            cand --byte-range 'The range of byte offsets in which the query will be executed'
            cand --row-range 'The range of rows in which the query will be executed'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Query the contents of a specific test'
            cand --test-number 'Query the contents of a specific test'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -c 'Order by captures instead of matches'
            cand --captures 'Order by captures instead of matches'
            cand --test 'Whether to run query tests or not'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;highlight'= {
            cand --captures-path 'The path to a file with captures'
            cand --query-paths 'The paths to files with queries'
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --paths 'The path to a file with paths to source file(s)'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Highlight the contents of a specific test'
            cand --test-number 'Highlight the contents of a specific test'
            cand -H 'Generate highlighting as an HTML document'
            cand --html 'Generate highlighting as an HTML document'
            cand --css-classes 'When generating HTML, use css classes rather than inline styles'
            cand --check 'Check that highlighting captures conform strictly to standards'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;tags'= {
            cand --scope 'Select a language by the scope instead of a file extension'
            cand --paths 'The path to a file with paths to source file(s)'
            cand --config-path 'The path to an alternative config.json file'
            cand -n 'Generate tags from the contents of a specific test'
            cand --test-number 'Generate tags from the contents of a specific test'
            cand -t 'Measure execution time'
            cand --time 'Measure execution time'
            cand -q 'Suppress main output'
            cand --quiet 'Suppress main output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;playground'= {
            cand --grammar-path 'Path to the directory containing the grammar and wasm files'
            cand -q 'Don''t open in default browser'
            cand --quiet 'Don''t open in default browser'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;dump-languages'= {
            cand --config-path 'The path to an alternative config.json file'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'tree-sitter;complete'= {
            cand -s 'The shell to generate completions for'
            cand --shell 'The shell to generate completions for'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
