/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.util.Pair;

class ListShardingKeys
implements ShardingKeys {
    private final NavigableSet<OracleShardingKeyImpl> keys;
    private final OracleShardingKeyImpl[] aKeys;

    ListShardingKeys(List<OracleShardingKeyImpl> keys) {
        this.keys = new TreeSet<OracleShardingKeyImpl>(keys);
        this.aKeys = this.keys.toArray(new OracleShardingKeyImpl[this.keys.size()]);
    }

    @Override
    public boolean contains(OracleShardingKey key) {
        return this.keys.contains(key);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardingKeys)) {
            return false;
        }
        ListShardingKeys oList = (ListShardingKeys)obj;
        return this.keys.equals(oList.keys);
    }

    public String toString() {
        if (this.keys == null || this.keys.isEmpty()) {
            return "";
        }
        return "[" + this.keys.stream().map(x -> x.toString()).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public int compareTo(ShardingKeys other) {
        int thatSize;
        if (other == null || !(other instanceof ListShardingKeys)) {
            return 1;
        }
        ListShardingKeys that = (ListShardingKeys)other;
        int thisSize = this.keys.size();
        int dif = thisSize - (thatSize = that.keys.size());
        if (0 != dif) {
            return dif;
        }
        for (int i = 0; i < thisSize; ++i) {
            int res = this.aKeys[i].compareTo((OracleShardingKey)that.aKeys[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public List<Pair<OracleShardingKey, OracleShardingKey>> getKeys() {
        ArrayList<Pair<OracleShardingKey, OracleShardingKey>> pairs = new ArrayList<Pair<OracleShardingKey, OracleShardingKey>>();
        for (int i = 0; i < this.aKeys.length; ++i) {
            pairs.add(new Pair<OracleShardingKeyImpl, OracleShardingKeyImpl>(this.aKeys[i], this.aKeys[i]));
        }
        return pairs;
    }
}

