/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;

public class UniversalConnectionPoolManagerHelper {
    private final UniversalConnectionPool m_connectionPool;
    private static UniversalConnectionPoolManagerImpl m_mgrImpl;

    public UniversalConnectionPoolManagerHelper(UniversalConnectionPool connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        this.m_connectionPool = connectionPool;
        m_mgrImpl = (UniversalConnectionPoolManagerImpl)UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager(DiagnosticsCollectorImpl.getCommon());
    }

    public void setManagerPoolID(String poolName) throws UniversalConnectionPoolException {
        m_mgrImpl.setManagerPoolID(this.m_connectionPool.getName(), poolName);
    }

    public String getManagerPoolID() throws UniversalConnectionPoolException {
        return m_mgrImpl.getManagerPoolID(this.m_connectionPool.getName()) + ",poolName=" + this.m_connectionPool.getName();
    }

    public void setMetricConsole(DMSConsole metricConsole) {
        m_mgrImpl.setMetricConsole(metricConsole);
    }

    public void setMetricParentNoun(NounIntf metricParentNoun) {
        m_mgrImpl.setMetricParentNoun(this.m_connectionPool.getName(), metricParentNoun);
    }

    public StateIntf getStateMetric(UniversalConnectionPoolManagerBase.UCPMetric ucpMetric) {
        return m_mgrImpl.getStateMetric(this.m_connectionPool.getName(), ucpMetric);
    }
}

