/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContextKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualIncompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.MemberIncompatibility;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J-\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012JO\u0010\u001c\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00102 \u0010\u001d\u001a\u001c\u0012\u0004\u0012\u00020\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 0\u001ej\u0002`\"H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010#J]\u0010$\u001a\u00020\u00072\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020!2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010+JO\u0010,\u001a\u00020\u00072\u0016\u0010-\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0.0 2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u000200H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00101JG\u00102\u001a\u00020\u00072\n\u00103\u001a\u0006\u0012\u0002\b\u00030!2\n\u00104\u001a\u0006\u0012\u0002\b\u00030!2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00105JG\u00102\u001a\u00020\u00072\u0016\u00106\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0.0 2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00107J\"\u00108\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030!2\b\u00109\u001a\u0004\u0018\u0001002\u0006\u0010:\u001a\u00020;H\u0002J]\u0010<\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0=0 2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030!2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030!2\b\u0010@\u001a\u0004\u0018\u0001002\b\u00109\u001a\u0004\u0018\u0001002\u0006\u0010:\u001a\u00020;H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010AJ[\u0010B\u001a\u00020\u00072\n\u0010C\u001a\u0006\u0012\u0002\b\u00030!2\u001c\u0010D\u001a\u0018\u0012\u0004\u0012\u00020\u001f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 0\u001e2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030!H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010EJ$\u0010F\u001a\u00020\u000f2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010@\u001a\u0002002\u0006\u0010G\u001a\u00020HH\u0002J\f\u0010I\u001a\u00020\u000f*\u00020JH\u0002J$\u0010K\u001a\u00020\u000f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010@\u001a\u0002002\u0006\u0010G\u001a\u00020HH\u0002\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "containsExpectOrActualModifier", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkExpectDeclarationModifiers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)V", "checkExpectPropertyAccessorsModifiers", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkExpectPropertyAccessorModifiers", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)V", "checkExpectDeclarationHasNoExternalModifier", "checkActualDeclarationHasExpected", "matchingCompatibilityToMembersMap", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/ExpectForActualMatchingData;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Ljava/util/Map;)V", "reportClassScopesIncompatibility", "symbol", "expectedSingleCandidate", "checkingCompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility$ClassScopes;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility$ClassScopes;Lorg/jetbrains/kotlin/KtSourceElement;)V", "reportDefaultArgsIncompatibleMembers", "defaultArgsIncompatibleMembers", "Lorg/jetbrains/kotlin/resolve/multiplatform/MemberIncompatibility;", "expectClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "reportIgnorabilityIncompatibleMembers", "expect", "actual", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)V", "ignorabilityIncompatibleMembers", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;Lorg/jetbrains/kotlin/KtSourceElement;)V", "isFakeOverride", "expectContainingClass", "expectActualMatchingContext", "Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "getCheckingCompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility;", "actualSymbol", "expectSymbol", "actualContainingClass", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;)Ljava/util/List;", "checkAmbiguousExpects", "actualDeclaration", "compatibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "requireActualModifier", "platformSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasActualModifier", "Lorg/jetbrains/kotlin/fir/FirElement;", "isUnderlyingPropertyOfInlineClass", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,452:1\n35#2:453\n34#2:454\n35#2:455\n52#2:456\n53#2:457\n35#2:458\n75#3,14:459\n2792#4,3:473\n832#4:476\n862#4,2:477\n777#4:479\n873#4,2:480\n777#4:482\n873#4,2:483\n832#4:485\n862#4,2:486\n1586#4:488\n1661#4,3:489\n1586#4:493\n1661#4,3:494\n1068#4:497\n1#5:492\n63#6:498\n57#6,4:499\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n39#1:453\n39#1:454\n59#1:455\n85#1:456\n120#1:457\n155#1:458\n182#1:459,14\n202#1:473,3\n229#1:476\n229#1:477,2\n233#1:479\n233#1:480,2\n239#1:482\n239#1:483,2\n244#1:485\n244#1:486,2\n277#1:488\n277#1:489,3\n365#1:493\n365#1:494,3\n366#1:497\n414#1:498\n414#1:499,4\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> matchingCompatibilityToMembersMap;
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<Object>>> map;
        block10: {
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    if (!(declaration instanceof FirMemberDeclaration)) {
                        return;
                    }
                    if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.MultiPlatformProjects)) break block10;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) break block11;
                    FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration;
                    boolean $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) break block12;
                }
                if (this.containsExpectOrActualModifier((FirMemberDeclaration)declaration)) {
                    Object object = ((FirMemberDeclaration)declaration).getSource();
                    boolean bl = object != null && (object = ((KtSourceElement)object).getKind()) != null ? !((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false;
                    if (bl) {
                        KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirMemberDeclaration)declaration).getSource(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), (AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getEXPECT_ACTUAL_MODIFIER());
                    }
                }
            }
            return;
        }
        if (declaration instanceof FirBackingField || declaration instanceof FirPropertyAccessor || declaration instanceof FirValueParameter) {
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            this.checkExpectDeclarationModifiers(context2, reporter, (FirMemberDeclaration)declaration);
        }
        if ((map = ExpectActualAttributesKt.getExpectForActual(((FirMemberDeclaration)declaration).getSymbol())) == null) {
            map = MapsKt.emptyMap();
        }
        if (((matchingCompatibilityToMembersMap = map).containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) || this.hasActualModifier(declaration)) && !DeclarationUtilsKt.isLocalMember(declaration)) {
            this.checkActualDeclarationHasExpected(context2, reporter, (FirMemberDeclaration)declaration, matchingCompatibilityToMembersMap);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsExpectOrActualModifier(FirMemberDeclaration declaration) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(declaration.getSource());
        if (firModifierList == null) return false;
        FirModifierList modifiers = firModifierList;
        boolean bl = false;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "EXPECT_KEYWORD");
        if (modifiers.contains(ktModifierKeywordToken)) return true;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "ACTUAL_KEYWORD");
        if (!modifiers.contains(ktModifierKeywordToken2)) return false;
        return true;
    }

    private final void checkExpectDeclarationModifiers(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration) {
        this.checkExpectDeclarationHasNoExternalModifier(context2, reporter, declaration);
        if (declaration instanceof FirProperty) {
            this.checkExpectPropertyAccessorsModifiers(context2, reporter, (FirProperty)declaration);
        }
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.MultiplatformRestrictions) && declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isTailRec$iv = declaration;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), null, 8, null);
            }
        }
    }

    private final void checkExpectPropertyAccessorsModifiers(CheckerContext context2, DiagnosticReporter reporter, FirProperty property2) {
        FirPropertyAccessor[] firPropertyAccessorArray = new FirPropertyAccessor[]{property2.getGetter(), property2.getSetter()};
        for (FirPropertyAccessor accessor : CollectionsKt.listOfNotNull(firPropertyAccessorArray)) {
            this.checkExpectPropertyAccessorModifiers(context2, reporter, accessor);
        }
    }

    private final void checkExpectPropertyAccessorModifiers(CheckerContext context2, DiagnosticReporter reporter, FirPropertyAccessor accessor) {
        if (!FirExpectActualDeclarationChecker.checkExpectPropertyAccessorModifiers$isDefault(accessor)) {
            this.checkExpectDeclarationHasNoExternalModifier(context2, reporter, accessor);
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration) {
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.MultiplatformRestrictions)) {
            FirMemberDeclaration $this$isExternal$iv = declaration;
            boolean $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), null, 8, null);
            }
        }
    }

    private final void checkActualDeclarationHasExpected(CheckerContext context2, DiagnosticReporter reporter, FirMemberDeclaration declaration, Map<ExpectActualMatchingCompatibility, ? extends List<? extends FirBasedSymbol<?>>> matchingCompatibilityToMembersMap) {
        boolean bl;
        List classScopesIncompatibilities;
        KtSourceElement source;
        FirBasedSymbol<?> expectedSingleCandidate;
        FirBasedSymbol<FirDeclaration> symbol;
        block14: {
            FirRegularClassSymbol actualContainingClass;
            symbol = declaration.getSymbol();
            List<? extends FirBasedSymbol<?>> list = matchingCompatibilityToMembersMap.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
            expectedSingleCandidate = list != null ? CollectionsKt.singleOrNull(list) : null;
            FirExpectActualMatchingContext expectActualMatchingContext = FirExpectActualMatchingContextKt.getExpectActualMatchingContextFactory(context2.getSession()).create(context2.getSession(), context2.getScopeSession(), true);
            FirBasedSymbol<?> firBasedSymbol = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
            FirRegularClassSymbol firRegularClassSymbol = actualContainingClass = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
            FirBasedSymbol<?> firBasedSymbol2 = firRegularClassSymbol != null ? ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(firRegularClassSymbol) : null;
            FirRegularClassSymbol expectContainingClass = firBasedSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol2 : null;
            List checkingIncompatibilities = expectedSingleCandidate != null ? this.getCheckingCompatibility(context2, symbol, expectedSingleCandidate, actualContainingClass, expectContainingClass, expectActualMatchingContext) : CollectionsKt.emptyList();
            this.checkAmbiguousExpects(context2, reporter, symbol, matchingCompatibilityToMembersMap, symbol);
            source = declaration.getSource();
            if (!this.hasActualModifier(declaration)) {
                FirMemberDeclaration $this$isExpect$iv = declaration;
                boolean $i$f$isExpect = false;
                if (!$this$isExpect$iv.getStatus().isExpect() && matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) && (actualContainingClass == null || this.requireActualModifier(symbol, actualContainingClass, context2.getSession())) && expectedSingleCandidate != null && !this.isFakeOverride(expectedSingleCandidate, expectContainingClass, expectActualMatchingContext)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), null, 8, null);
                    return;
                }
            }
            if (!matchingCompatibilityToMembersMap.containsKey(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE) || expectedSingleCandidate != null && this.hasActualModifier(declaration) && this.isFakeOverride(expectedSingleCandidate, expectContainingClass, expectActualMatchingContext)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol, matchingCompatibilityToMembersMap, null, 32, null);
                return;
            }
            Iterable $this$partitionIsInstance$iv = checkingIncompatibilities;
            boolean $i$f$partitionIsInstance = false;
            Iterable $this$partitionNotNull$iv$iv = $this$partitionIsInstance$iv;
            boolean $i$f$partitionNotNull = false;
            ArrayList<ExpectActualIncompatibility.ClassScopes> first$iv$iv = new ArrayList<ExpectActualIncompatibility.ClassScopes>();
            ArrayList second$iv$iv = new ArrayList();
            Iterator iterator2 = $this$partitionNotNull$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ExpectActualIncompatibility.ClassScopes result$iv$iv;
                Object element$iv$iv;
                Object it$iv = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                Object t2 = it$iv;
                if (!(t2 instanceof ExpectActualIncompatibility.ClassScopes)) {
                    t2 = null;
                }
                boolean bl3 = (result$iv$iv = (ExpectActualIncompatibility.ClassScopes)t2) != null ? first$iv$iv.add(result$iv$iv) : second$iv$iv.add(element$iv$iv);
            }
            Pair pair = new Pair(first$iv$iv, second$iv$iv);
            classScopesIncompatibilities = pair.component1();
            List normalIncompatibilities = pair.component2();
            for (ExpectActualIncompatibility incompatibility : normalIncompatibilities) {
                if (!(expectedSingleCandidate != null)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (declaration instanceof FirFunction && Intrinsics.areEqual(incompatibility, ExpectActualIncompatibility.ActualFunctionWithOptionalParameters.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirErrors.INSTANCE.getACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS(), null, 8, null);
                    continue;
                }
                if (Intrinsics.areEqual(incompatibility, ExpectActualIncompatibility.IgnorabilityIsDifferent.INSTANCE)) {
                    this.reportIgnorabilityIncompatibleMembers(reporter, context2, expectedSingleCandidate, symbol, source);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirExpectActualDeclarationCheckerKt.access$toDiagnostic(incompatibility), expectedSingleCandidate, symbol, (Object)incompatibility.getReason(), null, 64, null);
            }
            Iterable $this$none$iv = normalIncompatibilities;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ExpectActualIncompatibility it = (ExpectActualIncompatibility)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof ExpectActualIncompatibility.ClassKind || it instanceof ExpectActualIncompatibility.Modality)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            for (ExpectActualIncompatibility.ClassScopes incompatibility : classScopesIncompatibilities) {
                this.reportClassScopesIncompatibility(reporter, context2, symbol, expectedSingleCandidate, incompatibility, source);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportClassScopesIncompatibility(DiagnosticReporter reporter, CheckerContext context2, FirBasedSymbol<? extends FirDeclaration> symbol, FirBasedSymbol<?> expectedSingleCandidate, ExpectActualIncompatibility.ClassScopes<FirBasedSymbol<?>> checkingCompatibility, KtSourceElement source) {
        void $this$filterNotTo$iv$iv;
        if (!((symbol instanceof FirRegularClassSymbol || symbol instanceof FirTypeAliasSymbol) && expectedSingleCandidate instanceof FirRegularClassSymbol)) {
            boolean $i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22 = false;
            String $i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + symbol + ' ' + expectedSingleCandidate;
            throw new IllegalArgumentException($i$a$-require-FirExpectActualDeclarationChecker$reportClassScopesIncompatibility$22.toString());
        }
        Iterable $this$filterNot$iv = checkingCompatibility.getIncompatibleMembers();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MemberIncompatibility p0 = (MemberIncompatibility)element$iv$iv;
            boolean bl = false;
            if (FirExpectActualDeclarationChecker.reportClassScopesIncompatibility$hasSingleActualSuspect(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonTrivialIncompatibleMembers = (List)destination$iv$iv;
        if (!((Collection)nonTrivialIncompatibleMembers).isEmpty()) {
            void $this$filterNotTo$iv$iv2;
            MemberIncompatibility it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$filterNot$iv = nonTrivialIncompatibleMembers;
            CheckerContext checkerContext = context2;
            DiagnosticReporter diagnosticReporter = reporter;
            FirExpectActualDeclarationChecker firExpectActualDeclarationChecker = this;
            boolean $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MemberIncompatibility)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getIncompatibility(), ExpectActualIncompatibility.ParametersWithDefaultValuesInExpectActualizedByFakeOverride.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            firExpectActualDeclarationChecker.reportDefaultArgsIncompatibleMembers(diagnosticReporter, checkerContext, list, source, (FirRegularClassSymbol)expectedSingleCandidate);
            $this$filter$iv = nonTrivialIncompatibleMembers;
            checkerContext = context2;
            diagnosticReporter = reporter;
            firExpectActualDeclarationChecker = this;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MemberIncompatibility)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getIncompatibility(), ExpectActualIncompatibility.IgnorabilityIsDifferent.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            firExpectActualDeclarationChecker.reportIgnorabilityIncompatibleMembers(diagnosticReporter, checkerContext, list, source);
            Iterable $this$filterNot$iv2 = nonTrivialIncompatibleMembers;
            boolean $i$f$filterNot2 = false;
            destination$iv$iv = $this$filterNot$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                MemberIncompatibility it2 = (MemberIncompatibility)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(it2.getIncompatibility(), ExpectActualIncompatibility.IgnorabilityIsDifferent.INSTANCE) || Intrinsics.areEqual(it2.getIncompatibility(), ExpectActualIncompatibility.ParametersWithDefaultValuesInExpectActualizedByFakeOverride.INSTANCE)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List otherIncompatibleMembers = (List)destination$iv$iv2;
            if (!((Collection)otherIncompatibleMembers).isEmpty()) {
                for (MemberIncompatibility member : otherIncompatibleMembers) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_ACTUAL_INCOMPATIBLE_CLASS_SCOPE(), symbol, member.getExpect(), member.getActual(), (Object)member.getIncompatibility().getReason(), null, 128, null);
                }
            }
        }
        if (!((Collection)checkingCompatibility.getMismatchedMembers()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol, checkingCompatibility.getMismatchedMembers(), null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDefaultArgsIncompatibleMembers(DiagnosticReporter reporter, CheckerContext context2, List<? extends MemberIncompatibility<? extends FirBasedSymbol<?>>> defaultArgsIncompatibleMembers, KtSourceElement source, FirRegularClassSymbol expectClass) {
        if (!((Collection)defaultArgsIncompatibleMembers).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = defaultArgsIncompatibleMembers;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MemberIncompatibility memberIncompatibility = (MemberIncompatibility)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object d2 = it.getExpect();
                FirNamedFunctionSymbol firNamedFunctionSymbol = d2 instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)d2 : null;
                if (firNamedFunctionSymbol == null) {
                    throw new IllegalStateException((ExpectActualIncompatibility.ParametersWithDefaultValuesInExpectActualizedByFakeOverride.INSTANCE + " can be reported only for " + Reflection.getOrCreateKotlinClass(FirNamedFunctionSymbol.class)).toString());
                }
                collection.add(firNamedFunctionSymbol);
            }
            List problematicExpectMembers = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_ACTUALIZED_BY_FAKE_OVERRIDE(), (Object)expectClass, (Object)problematicExpectMembers, null, 32, null);
        }
    }

    private final void reportIgnorabilityIncompatibleMembers(DiagnosticReporter reporter, CheckerContext context2, FirBasedSymbol<?> expect, FirBasedSymbol<?> actual, KtSourceElement source) {
        FirCallableSymbol firCallableSymbol = expect instanceof FirCallableSymbol ? (FirCallableSymbol)expect : null;
        if (firCallableSymbol == null) {
            throw new IllegalStateException("Ignorability incompatibility can be reported only for callables".toString());
        }
        FirCallableSymbol expectMember = firCallableSymbol;
        FirCallableSymbol firCallableSymbol2 = actual instanceof FirCallableSymbol ? (FirCallableSymbol)actual : null;
        if (firCallableSymbol2 == null) {
            throw new IllegalStateException("Ignorability incompatibility can be reported only for callables".toString());
        }
        FirCallableSymbol actualMember = firCallableSymbol2;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_IGNORABILITY_NOT_MATCH_EXPECT(), (Object)expectMember, (Object)expectMember.getResolvedStatus().getReturnValueStatus(), (Object)actualMember, (Object)actualMember.getResolvedStatus().getReturnValueStatus(), null, 128, null);
    }

    private final void reportIgnorabilityIncompatibleMembers(DiagnosticReporter reporter, CheckerContext context2, List<? extends MemberIncompatibility<? extends FirBasedSymbol<?>>> ignorabilityIncompatibleMembers, KtSourceElement source) {
        for (MemberIncompatibility<FirBasedSymbol<?>> member : ignorabilityIncompatibleMembers) {
            this.reportIgnorabilityIncompatibleMembers(reporter, context2, member.getExpect(), member.getActual(), source);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFakeOverride(FirBasedSymbol<?> $this$isFakeOverride, FirRegularClassSymbol expectContainingClass, FirExpectActualMatchingContext expectActualMatchingContext) {
        if (expectContainingClass == null) return false;
        if (!($this$isFakeOverride instanceof FirCallableSymbol)) return false;
        FirExpectActualMatchingContext $this$isFakeOverride_u24lambda_u240 = expectActualMatchingContext;
        boolean bl = false;
        if (!$this$isFakeOverride_u24lambda_u240.isFakeOverride((CallableSymbolMarker)((Object)$this$isFakeOverride), expectContainingClass)) return false;
        return true;
    }

    private final List<ExpectActualIncompatibility<FirBasedSymbol<?>>> getCheckingCompatibility(CheckerContext context2, FirBasedSymbol<?> actualSymbol, FirBasedSymbol<?> expectSymbol, FirRegularClassSymbol actualContainingClass, FirRegularClassSymbol expectContainingClass, FirExpectActualMatchingContext expectActualMatchingContext) {
        List<ExpectActualIncompatibility<FirBasedSymbol<?>>> list;
        if (actualSymbol instanceof FirCallableSymbol && expectSymbol instanceof FirCallableSymbol) {
            list = AbstractExpectActualChecker.INSTANCE.getCallablesCompatibility((CallableSymbolMarker)((Object)expectSymbol), (CallableSymbolMarker)((Object)actualSymbol), expectContainingClass, actualContainingClass, expectActualMatchingContext, context2.getLanguageVersionSettings());
        } else if (actualSymbol instanceof FirClassLikeSymbol && expectSymbol instanceof RegularClassSymbolMarker) {
            list = AbstractExpectActualChecker.INSTANCE.getClassifiersCompatibility((RegularClassSymbolMarker)((Object)expectSymbol), (ClassLikeSymbolMarker)((Object)actualSymbol), expectActualMatchingContext, context2.getLanguageVersionSettings());
        } else {
            throw new IllegalStateException("These expect/actual shouldn't have been matched by FirExpectActualResolver".toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(CheckerContext context2, DiagnosticReporter reporter, FirBasedSymbol<?> actualDeclaration, Map<ExpectActualMatchingCompatibility, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List<FirBasedSymbol<Object>> list = compatibility.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirBasedSymbol firBasedSymbol = (FirBasedSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getModuleData());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List filesWithMatchedExpects = CollectionsKt.toList(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                FirModuleData it = (FirModuleData)a2;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName().asString()));
            }
        }));
        if (filesWithMatchedExpects.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol, filesWithMatchedExpects, null, 32, null);
        }
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration, FirRegularClassSymbol actualContainingClass, FirSession platformSession) {
        KtSourceElement source = declaration.getSource();
        if (!(source != null)) {
            boolean bl = false;
            String string = "expect-actual matching is only possible for code with sources";
            throw new IllegalStateException(string.toString());
        }
        return !Intrinsics.areEqual(source.getKind(), KtFakeSourceElementKind.ImplicitConstructor.INSTANCE) && !Intrinsics.areEqual(declaration.getOrigin(), FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE) && !org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isAnnotationConstructor(declaration, platformSession) && !org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration, platformSession) && !this.isUnderlyingPropertyOfInlineClass(declaration, actualContainingClass, platformSession);
    }

    private final boolean hasActualModifier(FirElement $this$hasActualModifier) {
        boolean bl;
        KtSourceElementKind ktSourceElementKind;
        KtSourceElement ktSourceElement = $this$hasActualModifier.getSource();
        KtSourceElementKind ktSourceElementKind2 = ktSourceElementKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (ktSourceElementKind == null) {
            bl = false;
        } else if (Intrinsics.areEqual(ktSourceElementKind, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(ktSourceElementKind, KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual(ktSourceElementKind, KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
            bl = false;
        } else {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ACTUAL_KEYWORD;
            Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "ACTUAL_KEYWORD");
            bl = FirKeywordUtilsKt.hasModifier($this$hasActualModifier, ktModifierKeywordToken);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderlyingPropertyOfInlineClass(FirBasedSymbol<?> symbol, FirRegularClassSymbol actualContainingClass, FirSession platformSession) {
        FirClassLikeSymbol $this$isInlineOrValue$iv = actualContainingClass;
        boolean $i$f$isInlineOrValue = false;
        FirClassLikeSymbol $this$isInline$iv$iv = $this$isInlineOrValue$iv;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv$iv.getRawStatus().isInline()) {
            FirClassLikeSymbol $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            boolean $i$f$isValue = false;
            if (!$this$isValue$iv$iv.getRawStatus().isValue()) return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (!(symbol instanceof FirPropertySymbol)) return false;
        Object object = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(actualContainingClass, platformSession);
        if (!Intrinsics.areEqual(object != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null ? (FirValueParameterSymbol)CollectionsKt.singleOrNull(object) : null, DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor((FirPropertySymbol)symbol))) return false;
        return true;
    }

    private static final boolean checkExpectPropertyAccessorModifiers$isDefault(FirPropertyAccessor $this$checkExpectPropertyAccessorModifiers_u24isDefault) {
        KtSourceElement source = $this$checkExpectPropertyAccessorModifiers_u24isDefault.getSource();
        if (!(source != null)) {
            boolean bl = false;
            String string = "expect-actual matching is only possible for code with sources";
            throw new IllegalStateException(string.toString());
        }
        return Intrinsics.areEqual(source.getKind(), KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
    }

    private static final boolean reportClassScopesIncompatibility$hasSingleActualSuspect(MemberIncompatibility<? extends FirBasedSymbol<?>> incompatibility) {
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> map = ExpectActualAttributesKt.getExpectForActual(incompatibility.getActual().getFir());
        return Intrinsics.areEqual(map != null && (map = map.values()) != null && (map = (List)CollectionsKt.singleOrNull((Iterable)((Object)map))) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(map) : null, incompatibility.getExpect());
    }
}

