/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type FunctionCall } from '@google/genai';
export declare enum MessageBusType {
    TOOL_CONFIRMATION_REQUEST = "tool-confirmation-request",
    TOOL_CONFIRMATION_RESPONSE = "tool-confirmation-response",
    TOOL_POLICY_REJECTION = "tool-policy-rejection",
    TOOL_EXECUTION_SUCCESS = "tool-execution-success",
    TOOL_EXECUTION_FAILURE = "tool-execution-failure",
    UPDATE_POLICY = "update-policy"
}
export interface ToolConfirmationRequest {
    type: MessageBusType.TOOL_CONFIRMATION_REQUEST;
    toolCall: FunctionCall;
    correlationId: string;
}
export interface ToolConfirmationResponse {
    type: MessageBusType.TOOL_CONFIRMATION_RESPONSE;
    correlationId: string;
    confirmed: boolean;
    /**
     * When true, indicates that policy decision was ASK_USER and the tool should
     * show its legacy confirmation UI instead of auto-proceeding.
     */
    requiresUserConfirmation?: boolean;
}
export interface UpdatePolicy {
    type: MessageBusType.UPDATE_POLICY;
    toolName: string;
}
export interface ToolPolicyRejection {
    type: MessageBusType.TOOL_POLICY_REJECTION;
    toolCall: FunctionCall;
}
export interface ToolExecutionSuccess<T = unknown> {
    type: MessageBusType.TOOL_EXECUTION_SUCCESS;
    toolCall: FunctionCall;
    result: T;
}
export interface ToolExecutionFailure<E = Error> {
    type: MessageBusType.TOOL_EXECUTION_FAILURE;
    toolCall: FunctionCall;
    error: E;
}
export type Message = ToolConfirmationRequest | ToolConfirmationResponse | ToolPolicyRejection | ToolExecutionSuccess | ToolExecutionFailure | UpdatePolicy;
