import { type AutoDetectTypes, type OpenOptionsFromBinding, type SetOptions } from "@serialport/bindings-cpp";
import { type ErrorCallback, SerialPortStream, type StreamOptions } from "@serialport/stream";
export type SerialPortOpenOptions<T extends AutoDetectTypes> = Omit<StreamOptions<T>, "binding"> & OpenOptionsFromBinding<T>;
export declare class SerialPort<T extends AutoDetectTypes = AutoDetectTypes> extends SerialPortStream<T> {
    static list: () => Promise<import("@serialport/bindings-cpp").PortInfo[]>;
    static readonly binding: AutoDetectTypes;
    constructor(options: SerialPortOpenOptions<T>, openCallback?: ErrorCallback);
    asyncOpen(): Promise<void>;
    asyncClose(): Promise<void>;
    asyncFlush(): Promise<void>;
    asyncFlushAndClose(): Promise<void>;
    asyncGet(): Promise<{
        cts: boolean;
        dsr: boolean;
        dcd: boolean;
    }>;
    asyncSet(options: SetOptions): Promise<void>;
}
//# sourceMappingURL=serialPort.d.ts.map