/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.channel.ChannelDuplexHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.server.HttpServerInfos;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;

class BaseAccessLogHandler
extends ChannelDuplexHandler {
    static final String DEFAULT_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {} {}";
    static final Function<AccessLogArgProvider, @Nullable AccessLog> DEFAULT_ACCESS_LOG = args -> AccessLog.create(DEFAULT_LOG_FORMAT, BaseAccessLogHandler.applyAddress(args.remoteAddress()), args.user(), args.zonedDateTime(), args.method(), args.uri(), args.protocol(), args.status(), args.contentLength() > -1L ? Long.valueOf(args.contentLength()) : "-", args.duration());
    final Function<AccessLogArgProvider, @Nullable AccessLog> accessLog;

    BaseAccessLogHandler(@Nullable Function<AccessLogArgProvider, @Nullable AccessLog> accessLog) {
        this.accessLog = accessLog == null ? DEFAULT_ACCESS_LOG : accessLog;
    }

    static String applyAddress(@Nullable SocketAddress socketAddress) {
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : "-";
    }

    static <T extends AbstractAccessLogArgProvider<T>> void applyServerInfos(AbstractAccessLogArgProvider<T> accessLogArgs, HttpServerInfos serverInfos) {
        accessLogArgs.cookies(serverInfos.cookies());
        accessLogArgs.connectionInformation(serverInfos);
    }
}

