/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchResponseSections;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class GenerativeSearchResponse
extends SearchResponse {
    private static final String EXT_SECTION_NAME = "ext";
    private static final String GENERATIVE_QA_ANSWER_FIELD_NAME = "answer";
    private static final String GENERATIVE_QA_ERROR_FIELD_NAME = "error";
    private static final String INTERACTION_ID_FIELD_NAME = "message_id";
    private final String answer;
    private String errorMessage;
    private final String interactionId;

    public GenerativeSearchResponse(String answer, String errorMessage, SearchResponseSections internalResponse, String scrollId, int totalShards, int successfulShards, int skippedShards, long tookInMillis, ShardSearchFailure[] shardFailures, SearchResponse.Clusters clusters, String interactionId) {
        super(internalResponse, scrollId, totalShards, successfulShards, skippedShards, tookInMillis, shardFailures, clusters);
        this.answer = answer;
        if (answer == null) {
            this.errorMessage = Objects.requireNonNull(errorMessage, "If answer is not given, errorMessage must be provided.");
        }
        this.interactionId = interactionId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.startObject(EXT_SECTION_NAME);
        builder.startObject("retrieval_augmented_generation");
        if (this.answer == null) {
            builder.field(GENERATIVE_QA_ERROR_FIELD_NAME, this.errorMessage);
        } else {
            builder.field(GENERATIVE_QA_ANSWER_FIELD_NAME, this.answer);
            if (this.interactionId != null) {
                builder.field(INTERACTION_ID_FIELD_NAME, this.interactionId);
            }
        }
        builder.endObject();
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

