/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.SlaterData;

abstract class MopacSlaterReader
extends SlaterReader {
    protected static final float MIN_COEF = 1.0E-4f;
    protected int[] atomicNumbers;
    protected float[][] mopacBasis;
    protected boolean allowMopacDCoef;
    private static final int[] principalQuantumNumber = new int[]{0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] npqd = new int[]{0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7};
    private static final int[] sphericalDValues = new int[]{0, -2, 0, 1, 0, 1, -2, 0, 0, 0, 1, 1, 1, 1, 0};
    private static Map<String, float[][]> mopacParams;
    public static final String MOPAC_TYPES = "AM1  MNDO PM3  PM6  PM7  RM1";
    static final float[] _AM1_C;
    private static final float[] _MNDO_C;
    private static final float[] _PM3_C;
    private static final float[] _PM6_C;
    private static final float[] _PM7_C;
    private static final float[] _RM1_C;

    MopacSlaterReader() {
    }

    @Override
    protected double scaleSlater(int ex, int ey, int ez, int er, double zeta) {
        int el = Math.abs(ex + ey + ez);
        switch (el) {
            case 0: {
                return MopacSlaterReader.getSlaterConstSSpherical(er + 1, Math.abs(zeta));
            }
            case 1: {
                return MopacSlaterReader.getSlaterConstPSpherical(er + 2, Math.abs(zeta));
            }
        }
        if (ex >= 0 && ey >= 0) {
            return super.scaleSlater(ex, ey, ez, er, zeta);
        }
        if (el == 3) {
            return 0.0;
        }
        return MopacSlaterReader.getSlaterConstDSpherical(el + er + 1, Math.abs(zeta), ex, ey);
    }

    private static final double getSlaterConstDSpherical(int n, double zeta, int ex, int ey) {
        return MopacSlaterReader.fact(15.0 / (double)(ex < 0 ? 12 : (ey < 0 ? 4 : 1)), zeta, n);
    }

    private static final double getSlaterConstSSpherical(int n, double zeta) {
        return Math.pow(2.0 * zeta, (double)n + 0.5) * Math.sqrt(0.07957747154594767 / fact_2n[n]);
    }

    private static final double getSlaterConstPSpherical(int n, double zeta) {
        double f = fact_2n[n] / 3.0;
        return Math.pow(2.0 * zeta, (double)n + 0.5) * Math.sqrt(0.07957747154594767 / f);
    }

    @Override
    public void setMOData(boolean clearOrbitals) {
        if (!this.allowNoOrbitals && this.orbitals.size() == 0) {
            return;
        }
        if (this.mopacBasis == null || !this.forceMOPAC && this.gaussians != null && this.shells != null) {
            if (this.forceMOPAC) {
                System.out.println("MopacSlaterReader ignoring MOPAC zeta parameters -- using Gaussian contractions");
            }
            super.setMOData(clearOrbitals);
            return;
        }
        this.setSlaters(false);
        this.moData.put("calculationType", this.calculationType);
        this.moData.put("energyUnits", this.energyUnits);
        this.moData.put("mos", this.orbitals);
        this.lastMoData = this.moData;
        this.finalizeMOData(this.lastMoData);
        if (clearOrbitals) {
            this.clearOrbitals();
        }
    }

    private static final int getNPQ(int atomicNumber) {
        return atomicNumber < principalQuantumNumber.length ? principalQuantumNumber[atomicNumber] : 0;
    }

    private static final int getNPQs(int atomicNumber) {
        int n = MopacSlaterReader.getNPQ(atomicNumber);
        switch (atomicNumber) {
            case 10: 
            case 18: 
            case 36: 
            case 54: 
            case 86: {
                return n + 1;
            }
        }
        return n;
    }

    private static final int getNPQp(int atomicNumber) {
        int n = MopacSlaterReader.getNPQ(atomicNumber);
        switch (atomicNumber) {
            case 2: {
                return n + 1;
            }
        }
        return n;
    }

    private static final int getNPQd(int atomicNumber) {
        return atomicNumber < npqd.length ? npqd[atomicNumber] : 0;
    }

    @Override
    protected void addSlaterBasis() {
        if (this.mopacBasis == null || this.slaters != null && this.slaters.size() > 0) {
            return;
        }
        int ac = this.asc.ac;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atoms = this.asc.atoms;
        for (int i = i0; i < ac; ++i) {
            short an = atoms[i].elementNumber;
            this.createMopacSlaters(i, an, this.mopacBasis[an], this.allowMopacDCoef);
        }
    }

    public void createMopacSlaters(int iAtom, int atomicNumber, float[] values, boolean allowD) {
        double zeta = values[0];
        if (zeta != 0.0) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "S", zeta, 1.0f);
        }
        if ((zeta = (double)values[1]) != 0.0) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Px", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Py", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Pz", zeta, 1.0f);
        }
        if ((zeta = (double)values[2]) != 0.0 && allowD) {
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dx2-y2", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dxz", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dz2", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dyz", zeta, 1.0f);
            this.createSphericalSlaterByType(iAtom, atomicNumber, "Dxy", zeta, 1.0f);
        }
    }

    protected void createSphericalSlaterByType(int iAtom, int atomicNumber, String type, double zeta, float coef) {
        int pt = "S Px Py Pz  Dx2-y2Dxz Dz2 Dyz Dxy".indexOf(type);
        switch (pt) {
            case 0: {
                SlaterData sd = this.addSlater(iAtom + 1, 0, 0, 0, MopacSlaterReader.getNPQs(atomicNumber) - 1, zeta, coef);
                sd.elemNo = atomicNumber;
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(iAtom + 1, pt == 2 ? 1 : 0, pt == 5 ? 1 : 0, pt == 8 ? 1 : 0, MopacSlaterReader.getNPQp(atomicNumber) - 2, zeta, coef);
                return;
            }
        }
        pt = (pt >> 2) * 3 - 9;
        this.addSlater(iAtom + 1, sphericalDValues[pt++], sphericalDValues[pt++], sphericalDValues[pt++], MopacSlaterReader.getNPQd(atomicNumber) - 3, zeta, coef);
    }

    public static float[][] getMopacAtomZetaSPD(String type) {
        float[][] params;
        if (mopacParams == null) {
            mopacParams = new Hashtable<String, float[][]>();
        }
        if ((params = mopacParams.get(type)) == null) {
            params = new float[120][3];
            mopacParams.put(type, params);
            float[] data = null;
            switch (MOPAC_TYPES.indexOf(type)) {
                case 0: {
                    data = _AM1_C;
                    break;
                }
                case 5: {
                    data = _MNDO_C;
                    break;
                }
                case 10: {
                    data = _PM3_C;
                    break;
                }
                case 15: {
                    data = _PM6_C;
                    break;
                }
                case 20: {
                    data = _PM7_C;
                    break;
                }
                case 25: {
                    MopacSlaterReader.addData(params, _AM1_C);
                    data = _RM1_C;
                    break;
                }
                default: {
                    System.err.println("MopacSlaterReader could not find MOPAC params for " + type);
                    return null;
                }
            }
            MopacSlaterReader.addData(params, data);
        }
        System.out.println("MopacSlaterReader using MOPAC params for " + type);
        return params;
    }

    private static void addData(float[][] params, float[] data) {
        int p = 0;
        int a = 0;
        for (int i = 0; i < data.length; ++i) {
            float d = data[i];
            if (d < 0.0f) {
                a = (int)(-d);
                p = 0;
                continue;
            }
            params[a][p++] = d;
        }
    }

    static {
        _AM1_C = new float[]{-1.0f, 1.188078f, -2.0f, 2.1956103f, 6.9012485f, -3.0f, 0.7973487f, 0.9045583f, -4.0f, 0.7425237f, 0.8080499f, -6.0f, 1.808665f, 1.685116f, -7.0f, 2.31541f, 2.15794f, -8.0f, 3.108032f, 2.524039f, -9.0f, 3.770082f, 2.49467f, -10.0f, 5.998377f, 4.1699305f, -11.0f, 0.789009f, 1.1399864f, -12.0f, 1.0128928f, 1.1798191f, -13.0f, 1.516593f, 1.306347f, -14.0f, 1.830697f, 1.284953f, -15.0f, 1.98128f, 1.87515f, -16.0f, 2.366515f, 1.667263f, -17.0f, 3.631376f, 2.076799f, -18.0f, 0.9714216f, 5.923623f, -19.0f, 1.2660244f, 0.9555939f, -20.0f, 1.1767755f, 1.273852f, -30.0f, 1.954299f, 1.372365f, -31.0f, 4.000216f, 1.3540466f, -32.0f, 1.219631f, 1.982794f, -33.0f, 2.2576897f, 1.724971f, -34.0f, 2.684157f, 2.0506165f, -35.0f, 3.064133f, 2.038333f, -36.0f, 3.5931633f, 2.0944633f, -37.0f, 4.0000186f, 1.0140619f, -38.0f, 1.5236849f, 1.5723524f, -42.0f, 1.945f, 1.477f, 2.468f, -49.0f, 1.8281575f, 1.48475f, -50.0f, 1.6182806f, 1.5084984f, -51.0f, 2.254823f, 2.218592f, -52.0f, 2.1321166f, 1.971268f, -53.0f, 2.102858f, 2.161153f, -54.0f, 4.9675245f, 3.1432142f, -55.0f, 5.7873707f, 1.0311693f, -56.0f, 1.9136517f, 1.3948894f, -80.0f, 2.036413f, 1.955766f, -81.0f, 3.8077333f, 1.5511578f, -82.0f, 2.443216f, 1.5506706f, -83.0f, 4.0007863f, 0.9547714f, -102.0f, 4.0f, 0.3f, 0.3f, -104.0f};
        _MNDO_C = new float[]{-1.0f, 1.331967f, -2.0f, 1.7710761f, 6.901826f, -3.0f, 0.4296141f, 0.7554884f, -4.0f, 1.00421f, 1.00421f, -5.0f, 1.506801f, 1.506801f, -6.0f, 1.787537f, 1.787537f, -7.0f, 2.255614f, 2.255614f, -8.0f, 2.699905f, 2.699905f, -9.0f, 2.848487f, 2.848487f, -10.0f, 5.9998746f, 4.17526f, -11.0f, 0.8213124f, 1.030327f, -12.0f, 0.9394811f, 1.3103428f, -13.0f, 1.444161f, 1.444161f, -14.0f, 1.315986f, 1.709943f, -15.0f, 2.10872f, 1.78581f, -16.0f, 2.312962f, 2.009146f, -17.0f, 3.784645f, 2.036263f, -18.0f, 0.9821697f, 5.999715f, -19.0f, 0.7276039f, 0.9871174f, -20.0f, 1.0034161f, 1.3102564f, -21.0f, 1.3951231f, 5.016094f, 0.9264186f, -22.0f, 0.8961552f, 0.9676159f, 1.8698884f, -23.0f, 1.2873544f, 1.1744379f, 2.015022f, -24.0f, 2.1495004f, 1.3131074f, 2.3289347f, -26.0f, 1.4536275f, 0.8933716f, 1.8691105f, -27.0f, 0.59975f, 0.607314f, 1.856797f, -28.0f, 0.7735888f, 6.0000134f, 2.7857108f, -29.0f, 3.3957872f, 1.786178f, 3.3573265f, -30.0f, 2.047359f, 1.460946f, -31.0f, 0.6986316f, 1.8386933f, -32.0f, 1.29318f, 2.020564f, -33.0f, 2.5614338f, 1.6117315f, -34.0f, 0.7242956f, 1.9267288f, -35.0f, 3.854302f, 2.1992092f, -36.0f, 3.5608623f, 1.9832062f, -37.0f, 4.000163f, 0.9187408f, -38.0f, 1.3729266f, 1.1118128f, -40.0f, 1.5386288f, 1.1472515f, 1.8744783f, -42.0f, 2.0001082f, 1.4112837f, 2.1944706f, -46.0f, 1.6942397f, 6.000013f, 2.2314825f, -47.0f, 2.615667f, 1.5209942f, 3.1178536f, -48.0f, 1.419249f, 1.0480638f, -49.0f, 1.762574f, 1.8648962f, -50.0f, 2.08038f, 1.937106f, -51.0f, 3.6458836f, 1.9733156f, -52.0f, 2.746161f, 1.6160376f, -53.0f, 2.272961f, 2.169498f, -54.0f, 4.990079f, 2.6929255f, -55.0f, 6.000417f, 0.8986916f, -56.0f, 1.9765973f, 1.3157347f, -78.0f, 1.8655763f, 1.9475781f, 2.8552253f, -80.0f, 2.218184f, 2.065038f, -81.0f, 4.000045f, 1.8076332f, -82.0f, 2.498286f, 2.082071f, -83.0f, 2.6772256f, 0.6936864f, -85.0f, -87.0f, -90.0f, 1.435306f, 1.435306f, -100.0f, -101.0f, -102.0f, 4.0f, 0.3f, 0.3f, -103.0f, -104.0f, -105.0f};
        _PM3_C = new float[]{-1.0f, 0.967807f, -2.0f, 1.7710761f, 6.901826f, -3.0f, 0.65f, 0.75f, -4.0f, 0.877439f, 1.508755f, -5.0f, 1.5312597f, 1.1434597f, -6.0f, 1.565085f, 1.842345f, -7.0f, 2.028094f, 2.313728f, -8.0f, 3.796544f, 2.389402f, -9.0f, 4.708555f, 2.491178f, -10.0f, 5.9998746f, 4.17526f, -11.0f, 2.6618938f, 0.8837425f, -12.0f, 0.698552f, 1.483453f, -13.0f, 1.702888f, 1.073629f, -14.0f, 1.635075f, 1.313088f, -15.0f, 2.017563f, 1.504732f, -16.0f, 1.891185f, 1.658972f, -17.0f, 2.24621f, 2.15101f, -18.0f, 0.9821697f, 5.999715f, -19.0f, 0.8101687f, 0.9578342f, -20.0f, 1.2087415f, 0.940937f, -30.0f, 1.819989f, 1.506922f, -31.0f, 1.84704f, 0.839411f, -32.0f, 2.2373526f, 1.5924319f, -33.0f, 2.636177f, 1.703889f, -34.0f, 2.828051f, 1.732536f, -35.0f, 5.348457f, 2.12759f, -36.0f, 3.5608623f, 1.9832062f, -37.0f, 4.0000415f, 1.013459f, -38.0f, 1.2794532f, 1.39125f, -48.0f, 1.679351f, 2.066412f, -49.0f, 2.016116f, 1.44535f, -50.0f, 2.373328f, 1.638233f, -51.0f, 2.343039f, 1.899992f, -52.0f, 4.165492f, 1.647555f, -53.0f, 7.001013f, 2.454354f, -54.0f, 4.990079f, 2.6929255f, -55.0f, 3.5960298f, 0.9255168f, -56.0f, 1.9258219f, 1.4519912f, -80.0f, 1.476885f, 2.479951f, -81.0f, 6.867921f, 1.969445f, -82.0f, 3.141289f, 1.892418f, -83.0f, 4.916451f, 1.934935f, -87.0f, -102.0f, 4.0f, 0.3f, -104.0f};
        _PM6_C = new float[]{-1.0f, 1.268641f, -2.0f, 3.313204f, 3.657133f, -3.0f, 0.981041f, 2.953445f, -4.0f, 1.212539f, 1.276487f, -5.0f, 1.634174f, 1.479195f, -6.0f, 2.047558f, 1.702841f, -7.0f, 2.380406f, 1.999246f, -8.0f, 5.421751f, 2.27096f, -9.0f, 6.043849f, 2.906722f, -10.0f, 6.000148f, 3.834528f, -11.0f, 0.686327f, 0.950068f, -12.0f, 1.31083f, 1.388897f, -13.0f, 2.364264f, 1.749102f, 1.269384f, -14.0f, 1.752741f, 1.198413f, 2.128593f, -15.0f, 2.158033f, 1.805343f, 1.230358f, -16.0f, 2.192844f, 1.841078f, 3.109401f, -17.0f, 2.63705f, 2.118146f, 1.324033f, -18.0f, 6.000272f, 5.94917f, -19.0f, 6.000478f, 1.127503f, -20.0f, 1.528258f, 2.060094f, -21.0f, 1.402469f, 1.345196f, 1.859012f, -22.0f, 5.324777f, 1.164068f, 1.41828f, -23.0f, 1.97433f, 1.063106f, 1.394806f, -24.0f, 3.28346f, 1.029394f, 1.623119f, -25.0f, 2.13168f, 1.52588f, 2.6078f, -26.0f, 1.47915f, 6.002246f, 1.080747f, -27.0f, 1.166613f, 3.0f, 1.860218f, -28.0f, 1.591828f, 2.304739f, 2.514761f, -29.0f, 1.669096f, 3.0f, 2.73499f, -30.0f, 1.512875f, 1.789482f, -31.0f, 2.339067f, 1.729592f, -32.0f, 2.546073f, 1.70913f, -33.0f, 2.926171f, 1.765191f, 1.392142f, -34.0f, 2.512366f, 2.007576f, -35.0f, 4.670684f, 2.035626f, 1.521031f, -36.0f, 1.312248f, 4.491371f, -37.0f, 5.510145f, 1.33517f, -38.0f, 2.197303f, 1.730137f, -39.0f, 0.593368f, 1.490422f, 1.650893f, -40.0f, 1.69259f, 1.694916f, 1.567392f, -41.0f, 2.355562f, 1.386907f, 1.977324f, -42.0f, 1.060429f, 1.350412f, 1.827152f, -43.0f, 1.956245f, 6.006299f, 1.76736f, -44.0f, 1.459195f, 5.537201f, 2.093164f, -45.0f, 1.324919f, 4.306111f, 2.901406f, -46.0f, 1.658503f, 1.156718f, 2.219861f, -47.0f, 1.994004f, 0.681817f, 6.007328f, -48.0f, 1.384108f, 1.957413f, -49.0f, 2.023087f, 2.106618f, -50.0f, 2.383941f, 2.057908f, -51.0f, 2.391178f, 1.773006f, 2.46559f, -52.0f, 2.769862f, 1.731319f, -53.0f, 4.498653f, 1.917072f, 1.875175f, -54.0f, 2.759787f, 1.977446f, -55.0f, 5.956008f, 1.619485f, -56.0f, 1.395379f, 1.430139f, -57.0f, 2.67378f, 1.248192f, 1.688562f, -71.0f, 5.471741f, 1.712296f, 2.225892f, -72.0f, 3.085344f, 1.575819f, 1.84084f, -73.0f, 4.578087f, 4.841244f, 1.838249f, -74.0f, 2.66456f, 1.62401f, 1.7944f, -75.0f, 2.411839f, 1.815351f, 2.522766f, -76.0f, 3.031f, 1.59396f, 1.77557f, -77.0f, 1.500907f, 4.106373f, 2.676047f, -78.0f, 2.301264f, 1.662404f, 3.168852f, -79.0f, 1.814169f, 1.618657f, 5.053167f, -80.0f, 2.104896f, 1.516293f, -81.0f, 3.335883f, 1.766141f, -82.0f, 2.368901f, 1.685246f, -83.0f, 3.702377f, 1.872327f, -85.0f, -87.0f, -90.0f, 1.435306f, 1.435306f, -97.0f, -98.0f, 2.0f, -100.0f, -101.0f, -102.0f, 4.0f, -103.0f, -104.0f, -105.0f};
        _PM7_C = new float[]{-1.0f, 1.260237f, -2.0f, 3.313204f, 3.657133f, -3.0f, 0.804974f, 6.02753f, -4.0f, 1.036199f, 1.764629f, -5.0f, 1.560481f, 1.449712f, -6.0f, 1.942244f, 1.708723f, -7.0f, 2.354344f, 2.028288f, -8.0f, 5.972309f, 2.349017f, -9.0f, 6.07003f, 2.930631f, -10.0f, 6.000148f, 3.834528f, -11.0f, 1.666701f, 1.397571f, -12.0f, 1.170297f, 1.840439f, -13.0f, 1.232599f, 1.219336f, 1.617502f, -14.0f, 1.433994f, 1.671776f, 1.221915f, -15.0f, 2.257933f, 1.555172f, 1.235995f, -16.0f, 2.046153f, 1.807678f, 3.510309f, -17.0f, 2.223076f, 2.264466f, 0.949994f, -18.0f, 6.000272f, 5.94917f, -19.0f, 5.422018f, 1.471023f, -20.0f, 1.477988f, 2.220194f, -21.0f, 1.794897f, 2.174934f, 5.99286f, -22.0f, 1.448579f, 1.940695f, 1.093648f, -23.0f, 6.051795f, 2.249871f, 1.087345f, -24.0f, 2.838413f, 1.37956f, 1.188729f, -25.0f, 1.66644f, 2.078735f, 2.89707f, -26.0f, 1.157576f, 2.737621f, 1.860792f, -27.0f, 1.789441f, 1.531664f, 1.951497f, -28.0f, 1.70834f, 2.000099f, 5.698724f, -29.0f, 1.735325f, 3.219976f, 6.013523f, -30.0f, 1.56014f, 1.915631f, -31.0f, 1.913326f, 1.811217f, -32.0f, 2.762845f, 1.531131f, -33.0f, 3.21385f, 1.628384f, 3.314358f, -34.0f, 2.75113f, 1.901764f, -35.0f, 3.72548f, 2.242318f, 1.591034f, -36.0f, 1.312248f, 4.491371f, -37.0f, 1.314831f, 6.015581f, -38.0f, 2.092264f, 3.314082f, -39.0f, 1.605083f, 2.131069f, 6.021645f, -40.0f, 1.373517f, 1.141705f, 1.618769f, -41.0f, 2.761686f, 5.999062f, 1.611677f, -42.0f, 1.595399f, 1.426575f, 1.787748f, -43.0f, 2.104672f, 2.669984f, 3.030496f, -44.0f, 1.605646f, 4.58082f, 1.244578f, -45.0f, 1.591465f, 4.546046f, 2.685918f, -46.0f, 5.790768f, 2.169788f, 1.327661f, -47.0f, 1.793032f, 2.528721f, 3.524808f, -48.0f, 3.670047f, 1.857036f, -49.0f, 1.902085f, 1.940127f, -50.0f, 1.959238f, 1.976146f, -51.0f, 1.9986f, 1.887062f, 1.475516f, -52.0f, 3.024819f, 2.598283f, -53.0f, 3.316202f, 2.449124f, 1.716121f, -54.0f, 3.208788f, 2.727979f, -55.0f, 1.776064f, 6.02531f, -56.0f, 1.75049f, 1.968788f, -57.0f, 3.398968f, 1.811983f, 1.894574f, -71.0f, 2.327039f, 6.000335f, 1.208414f, -72.0f, 2.854938f, 3.079458f, 2.067146f, -73.0f, 4.116264f, 3.380936f, 1.755408f, -74.0f, 3.881177f, 2.044717f, 1.928901f, -75.0f, 2.452162f, 1.583194f, 2.414839f, -76.0f, 3.094808f, 2.845232f, 1.986395f, -77.0f, 1.924564f, 3.510744f, 2.437796f, -78.0f, 2.922551f, 0.725689f, 2.158085f, -79.0f, 1.904923f, 2.408005f, 4.377691f, -80.0f, 2.575831f, 1.955505f, -81.0f, 1.903342f, 2.838647f, 5.015677f, -82.0f, 4.706006f, 2.591455f, -83.0f, 5.465413f, 2.037481f, 2.8554f, -85.0f, -87.0f, -90.0f, 1.435306f, 1.435306f, -97.0f, -98.0f, 2.0f, -100.0f, -101.0f, -102.0f, 4.0f, -103.0f, -104.0f, -105.0f};
        _RM1_C = new float[]{-1.0f, 1.0826737f, -6.0f, 1.850188f, 1.7683009f, -7.0f, 2.3744717f, 1.9781257f, -8.0f, 3.1793692f, 2.5536191f, -9.0f, 4.403379f, 2.6484156f, -15.0f, 2.1224012f, 1.7432795f, -16.0f, 2.133443f, 1.8746065f, -17.0f, 3.8649106f, 1.8959314f, -35.0f, 5.731572f, 2.0314758f, -53.0f, 2.5300374f, 2.3173869f, -57.0f, 1.272677f, 1.423276f, 1.410369f, -58.0f, 1.281028f, 1.425366f, 1.412866f, -59.0f, 1.538039f, 1.581647f, 1.374904f, -60.0f, 1.45829f, 1.570516f, 1.513561f, -61.0f, 1.065536f, 1.846925f, 1.424049f, -62.0f, 1.293914f, 1.738656f, 1.521378f, -63.0f, 1.350342f, 1.733714f, 1.494122f, -64.0f, 1.272776f, 1.908122f, 1.515905f, -65.0f, 1.210052f, 1.921514f, 1.528123f, -66.0f, 1.295275f, 1.912107f, 1.413397f, -67.0f, 1.33055f, 1.779559f, 1.536524f, -68.0f, 1.347757f, 1.806481f, 1.466189f, -69.0f, 1.369147f, 1.674365f, 1.714394f, -70.0f, 1.239808f, 1.849144f, 1.485378f, -71.0f, 1.425302f, 1.790353f, 1.642603f, -102.0f, 4.0f, 0.3f};
    }
}

