/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt.stubs;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt.base.stubs.KotlinPosition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR$\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/kapt/stubs/KaptLineMappingCollectorBase;", "", "<init>", "()V", "lineInfo", "", "", "Lorg/jetbrains/kotlin/kapt/base/stubs/KotlinPosition;", "Lorg/jetbrains/kotlin/kapt/base/stubs/LineInfoMap;", "getLineInfo", "()Ljava/util/Map;", "signatureInfo", "getSignatureInfo", "serialize", "", "kotlin-annotation-processing"})
public abstract class KaptLineMappingCollectorBase {
    @NotNull
    private final Map<String, KotlinPosition> lineInfo = new LinkedHashMap();
    @NotNull
    private final Map<String, String> signatureInfo = new LinkedHashMap();

    @NotNull
    protected final Map<String, KotlinPosition> getLineInfo() {
        return this.lineInfo;
    }

    @NotNull
    protected final Map<String, String> getSignatureInfo() {
        return this.signatureInfo;
    }

    @NotNull
    public final byte[] serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(1);
        oos.writeInt(this.lineInfo.size());
        for (Map.Entry<String, KotlinPosition> entry : this.lineInfo.entrySet()) {
            String fqName = entry.getKey();
            KotlinPosition kotlinPosition = entry.getValue();
            oos.writeUTF(fqName);
            oos.writeUTF(kotlinPosition.getPath());
            oos.writeBoolean(kotlinPosition.isRelativePath());
            oos.writeInt(kotlinPosition.getPos());
        }
        oos.writeInt(this.signatureInfo.size());
        for (Map.Entry<String, Object> entry : this.signatureInfo.entrySet()) {
            String javacSignature = entry.getKey();
            String methodDesc = (String)entry.getValue();
            oos.writeUTF(javacSignature);
            oos.writeUTF(methodDesc);
        }
        oos.flush();
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

